<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

add_filter( 'gform_ajax_spinner_url_5', 'spinner_url', 10, 2 );
function spinner_url( $image_src, $form ) {
    return  'https://www.svsinc.com.au/wp-content/uploads/2023/04/blank-500.gif' ;
    //return  get_bloginfo('template_directory') . '/images/blank.gif' ;
}
add_filter( 'gform_pre_render_5', 'add_readonly_script' );
function add_readonly_script( $form ) {
    ?>
    <script type="text/javascript">
        jQuery(document).on('gform_post_render', function(){
            /* apply only to a input with a class of gf_readonly */
            jQuery(".gf_readonly input").attr("readonly","readonly");
        });
    </script>
    <?php
    return $form;
}
// add_filter('wp_editor_settings', 'remove_gf_notification_visual_editor', 10, 2);
// function remove_gf_notification_visual_editor($settings, $editor_id) {

//   if ($editor_id === '_gform_setting_message') {
//     $settings['tinymce'] = false;
//   }
//   return $settings;
// }

/* Remove Visual Tab for Gravity Form and Gravity Flow  to avoid breaking the HTML Emails */
add_filter('wp_editor_settings', 'remove_gf_notification_visual_editor', 10, 2);
function remove_gf_notification_visual_editor($settings, $editor_id) {

  if ($editor_id === '_gform_setting_message') {
    $settings['tinymce'] = false;
  }elseif ($editor_id === '_gform_setting_assignee_notification_message') {
    $settings['tinymce'] = false;
  }
  return $settings;
}


//gravity forms custom template 

add_filter( 'gform_shortcode_conditional', function( $result, $atts, $content ) {

	if( ! isset( $atts['value'] ) || isset( $atts['merge_tag'] ) ) {
		return $result;
	}

	$relation   = strtolower( rgar( $atts, 'relation', 'all' ) ); // or 'any'
	$conditions = array();

	foreach( $atts as $key => $prop ) {

		preg_match( '|value(\d*)$|', $key, $match );
		if( ! empty( $match ) ) {
			list( , $index ) = $match;
			$conditions[] = array(
				'value'    => rgar( $atts, sprintf( 'value%s', $index ) ),
				'operator' => rgar( $atts, sprintf( 'operator%s', $index ) ),
				'compare'  => rgar( $atts, sprintf( 'compare%s', $index ) ),
			);
		}

	}

	$conditional_met = $relation == 'all';

	foreach( $conditions as $condition ) {
		$is_match = GFFormsModel::matches_operation( $condition['value'], $condition['compare'], $condition['operator'] );
		if( $relation == 'any' && $is_match ) {
			$conditional_met = true;
			break;
		} else if( $relation == 'all' && ! $is_match ) {
			$conditional_met = false;
		}
	}

	if( ! $conditional_met ) {
		return '';
	}

	// find and remove any starting/closing <br> tags
	if( rgar( $atts, 'format' ) != 'raw' ) {
		$content = preg_replace( '/^<br(?: *\/)?>|<br(?: *\/)?>$/', '', $content );
	}

	return do_shortcode( $content );
}, 10, 3 );