<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* PlannerCategoryDescriptions File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Beta\Microsoft\Graph\Model;
/**
* PlannerCategoryDescriptions class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class PlannerCategoryDescriptions extends Entity
{
    /**
    * Gets the category1
    * The label associated with Category 1
    *
    * @return string The category1
    */
    public function getCategory1()
    {
        if (array_key_exists("category1", $this->_propDict)) {
            return $this->_propDict["category1"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category1
    * The label associated with Category 1
    *
    * @param string $val The value of the category1
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory1($val)
    {
        $this->_propDict["category1"] = $val;
        return $this;
    }
    /**
    * Gets the category10
    * The label associated with Category 10
    *
    * @return string The category10
    */
    public function getCategory10()
    {
        if (array_key_exists("category10", $this->_propDict)) {
            return $this->_propDict["category10"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category10
    * The label associated with Category 10
    *
    * @param string $val The value of the category10
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory10($val)
    {
        $this->_propDict["category10"] = $val;
        return $this;
    }
    /**
    * Gets the category11
    * The label associated with Category 11
    *
    * @return string The category11
    */
    public function getCategory11()
    {
        if (array_key_exists("category11", $this->_propDict)) {
            return $this->_propDict["category11"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category11
    * The label associated with Category 11
    *
    * @param string $val The value of the category11
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory11($val)
    {
        $this->_propDict["category11"] = $val;
        return $this;
    }
    /**
    * Gets the category12
    * The label associated with Category 12
    *
    * @return string The category12
    */
    public function getCategory12()
    {
        if (array_key_exists("category12", $this->_propDict)) {
            return $this->_propDict["category12"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category12
    * The label associated with Category 12
    *
    * @param string $val The value of the category12
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory12($val)
    {
        $this->_propDict["category12"] = $val;
        return $this;
    }
    /**
    * Gets the category13
    * The label associated with Category 13
    *
    * @return string The category13
    */
    public function getCategory13()
    {
        if (array_key_exists("category13", $this->_propDict)) {
            return $this->_propDict["category13"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category13
    * The label associated with Category 13
    *
    * @param string $val The value of the category13
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory13($val)
    {
        $this->_propDict["category13"] = $val;
        return $this;
    }
    /**
    * Gets the category14
    * The label associated with Category 14
    *
    * @return string The category14
    */
    public function getCategory14()
    {
        if (array_key_exists("category14", $this->_propDict)) {
            return $this->_propDict["category14"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category14
    * The label associated with Category 14
    *
    * @param string $val The value of the category14
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory14($val)
    {
        $this->_propDict["category14"] = $val;
        return $this;
    }
    /**
    * Gets the category15
    * The label associated with Category 15
    *
    * @return string The category15
    */
    public function getCategory15()
    {
        if (array_key_exists("category15", $this->_propDict)) {
            return $this->_propDict["category15"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category15
    * The label associated with Category 15
    *
    * @param string $val The value of the category15
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory15($val)
    {
        $this->_propDict["category15"] = $val;
        return $this;
    }
    /**
    * Gets the category16
    * The label associated with Category 16
    *
    * @return string The category16
    */
    public function getCategory16()
    {
        if (array_key_exists("category16", $this->_propDict)) {
            return $this->_propDict["category16"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category16
    * The label associated with Category 16
    *
    * @param string $val The value of the category16
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory16($val)
    {
        $this->_propDict["category16"] = $val;
        return $this;
    }
    /**
    * Gets the category17
    * The label associated with Category 17
    *
    * @return string The category17
    */
    public function getCategory17()
    {
        if (array_key_exists("category17", $this->_propDict)) {
            return $this->_propDict["category17"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category17
    * The label associated with Category 17
    *
    * @param string $val The value of the category17
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory17($val)
    {
        $this->_propDict["category17"] = $val;
        return $this;
    }
    /**
    * Gets the category18
    * The label associated with Category 18
    *
    * @return string The category18
    */
    public function getCategory18()
    {
        if (array_key_exists("category18", $this->_propDict)) {
            return $this->_propDict["category18"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category18
    * The label associated with Category 18
    *
    * @param string $val The value of the category18
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory18($val)
    {
        $this->_propDict["category18"] = $val;
        return $this;
    }
    /**
    * Gets the category19
    * The label associated with Category 19
    *
    * @return string The category19
    */
    public function getCategory19()
    {
        if (array_key_exists("category19", $this->_propDict)) {
            return $this->_propDict["category19"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category19
    * The label associated with Category 19
    *
    * @param string $val The value of the category19
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory19($val)
    {
        $this->_propDict["category19"] = $val;
        return $this;
    }
    /**
    * Gets the category2
    * The label associated with Category 2
    *
    * @return string The category2
    */
    public function getCategory2()
    {
        if (array_key_exists("category2", $this->_propDict)) {
            return $this->_propDict["category2"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category2
    * The label associated with Category 2
    *
    * @param string $val The value of the category2
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory2($val)
    {
        $this->_propDict["category2"] = $val;
        return $this;
    }
    /**
    * Gets the category20
    * The label associated with Category 20
    *
    * @return string The category20
    */
    public function getCategory20()
    {
        if (array_key_exists("category20", $this->_propDict)) {
            return $this->_propDict["category20"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category20
    * The label associated with Category 20
    *
    * @param string $val The value of the category20
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory20($val)
    {
        $this->_propDict["category20"] = $val;
        return $this;
    }
    /**
    * Gets the category21
    * The label associated with Category 21
    *
    * @return string The category21
    */
    public function getCategory21()
    {
        if (array_key_exists("category21", $this->_propDict)) {
            return $this->_propDict["category21"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category21
    * The label associated with Category 21
    *
    * @param string $val The value of the category21
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory21($val)
    {
        $this->_propDict["category21"] = $val;
        return $this;
    }
    /**
    * Gets the category22
    * The label associated with Category 22
    *
    * @return string The category22
    */
    public function getCategory22()
    {
        if (array_key_exists("category22", $this->_propDict)) {
            return $this->_propDict["category22"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category22
    * The label associated with Category 22
    *
    * @param string $val The value of the category22
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory22($val)
    {
        $this->_propDict["category22"] = $val;
        return $this;
    }
    /**
    * Gets the category23
    * The label associated with Category 23
    *
    * @return string The category23
    */
    public function getCategory23()
    {
        if (array_key_exists("category23", $this->_propDict)) {
            return $this->_propDict["category23"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category23
    * The label associated with Category 23
    *
    * @param string $val The value of the category23
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory23($val)
    {
        $this->_propDict["category23"] = $val;
        return $this;
    }
    /**
    * Gets the category24
    * The label associated with Category 24
    *
    * @return string The category24
    */
    public function getCategory24()
    {
        if (array_key_exists("category24", $this->_propDict)) {
            return $this->_propDict["category24"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category24
    * The label associated with Category 24
    *
    * @param string $val The value of the category24
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory24($val)
    {
        $this->_propDict["category24"] = $val;
        return $this;
    }
    /**
    * Gets the category25
    * The label associated with Category 25
    *
    * @return string The category25
    */
    public function getCategory25()
    {
        if (array_key_exists("category25", $this->_propDict)) {
            return $this->_propDict["category25"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category25
    * The label associated with Category 25
    *
    * @param string $val The value of the category25
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory25($val)
    {
        $this->_propDict["category25"] = $val;
        return $this;
    }
    /**
    * Gets the category3
    * The label associated with Category 3
    *
    * @return string The category3
    */
    public function getCategory3()
    {
        if (array_key_exists("category3", $this->_propDict)) {
            return $this->_propDict["category3"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category3
    * The label associated with Category 3
    *
    * @param string $val The value of the category3
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory3($val)
    {
        $this->_propDict["category3"] = $val;
        return $this;
    }
    /**
    * Gets the category4
    * The label associated with Category 4
    *
    * @return string The category4
    */
    public function getCategory4()
    {
        if (array_key_exists("category4", $this->_propDict)) {
            return $this->_propDict["category4"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category4
    * The label associated with Category 4
    *
    * @param string $val The value of the category4
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory4($val)
    {
        $this->_propDict["category4"] = $val;
        return $this;
    }
    /**
    * Gets the category5
    * The label associated with Category 5
    *
    * @return string The category5
    */
    public function getCategory5()
    {
        if (array_key_exists("category5", $this->_propDict)) {
            return $this->_propDict["category5"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category5
    * The label associated with Category 5
    *
    * @param string $val The value of the category5
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory5($val)
    {
        $this->_propDict["category5"] = $val;
        return $this;
    }
    /**
    * Gets the category6
    * The label associated with Category 6
    *
    * @return string The category6
    */
    public function getCategory6()
    {
        if (array_key_exists("category6", $this->_propDict)) {
            return $this->_propDict["category6"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category6
    * The label associated with Category 6
    *
    * @param string $val The value of the category6
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory6($val)
    {
        $this->_propDict["category6"] = $val;
        return $this;
    }
    /**
    * Gets the category7
    * The label associated with Category 7
    *
    * @return string The category7
    */
    public function getCategory7()
    {
        if (array_key_exists("category7", $this->_propDict)) {
            return $this->_propDict["category7"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category7
    * The label associated with Category 7
    *
    * @param string $val The value of the category7
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory7($val)
    {
        $this->_propDict["category7"] = $val;
        return $this;
    }
    /**
    * Gets the category8
    * The label associated with Category 8
    *
    * @return string The category8
    */
    public function getCategory8()
    {
        if (array_key_exists("category8", $this->_propDict)) {
            return $this->_propDict["category8"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category8
    * The label associated with Category 8
    *
    * @param string $val The value of the category8
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory8($val)
    {
        $this->_propDict["category8"] = $val;
        return $this;
    }
    /**
    * Gets the category9
    * The label associated with Category 9
    *
    * @return string The category9
    */
    public function getCategory9()
    {
        if (array_key_exists("category9", $this->_propDict)) {
            return $this->_propDict["category9"];
        } else {
            return null;
        }
    }

    /**
    * Sets the category9
    * The label associated with Category 9
    *
    * @param string $val The value of the category9
    *
    * @return PlannerCategoryDescriptions
    */
    public function setCategory9($val)
    {
        $this->_propDict["category9"] = $val;
        return $this;
    }
}
